﻿//******************************************************************************************************
//  Measurement.cs - Gbtc
//
//  Copyright © 2010, Grid Protection Alliance.  All Rights Reserved.
//
//  Licensed to the Grid Protection Alliance (GPA) under one or more contributor license agreements. See
//  the NOTICE file distributed with this work for additional information regarding copyright ownership.
//  The GPA licenses this file to you under the Eclipse Public License -v 1.0 (the "License"); you may
//  not use this file except in compliance with the License. You may obtain a copy of the License at:
//
//      http://www.opensource.org/licenses/eclipse-1.0.php
//
//  Unless agreed to in writing, the subject software distributed under the License is distributed on an
//  "AS-IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. Refer to the
//  License for the specific language governing permissions and limitations.
//
//  Code Modification History:
//  ----------------------------------------------------------------------------------------------------
//  10/22/2009 - Mehulbhai P Thakkar
//       Generated original version of source code.
//
//******************************************************************************************************


using System;
namespace openPDCManager.Data.Entities
{
	public class Measurement
	{
		public string SignalID { get; set; }
		public int? HistorianID { get; set; }
		public int PointID { get; set; }
		public int? DeviceID { get; set; }
		public string PointTag { get; set; }
		public string AlternateTag { get; set; }
		public int SignalTypeID { get; set; }
		public int? PhasorSourceIndex { get; set; }
		public string SignalReference { get; set; }
		public double Adder { get; set; }
		public double Multiplier { get; set; }
		public string Description { get; set; }
		public bool Enabled { get; set; }
		public string HistorianAcronym { get; set; }
		public string DeviceAcronym { get; set; }
		public int? FramesPerSecond { get; set; }
		public string SignalName { get; set; }
		public string SignalAcronym { get; set; }
		public string SignalSuffix { get; set; }
		public string PhasorLabel { get; set; }
        public DateTime CreatedOn { get; set; }
        public string CreatedBy { get; set; }
        public DateTime UpdatedOn { get; set; }
        public string UpdatedBy { get; set; }
        public string ID { get; set; }
	}
}
