﻿//******************************************************************************************************
//  BooleanToColorConverter.cs - Gbtc
//
//  Copyright © 2010, Grid Protection Alliance.  All Rights Reserved.
//
//  Licensed to the Grid Protection Alliance (GPA) under one or more contributor license agreements. See
//  the NOTICE file distributed with this work for additional information regarding copyright ownership.
//  The GPA licenses this file to you under the Eclipse Public License -v 1.0 (the "License"); you may
//  not use this file except in compliance with the License. You may obtain a copy of the License at:
//
//      http://www.opensource.org/licenses/eclipse-1.0.php
//
//  Unless agreed to in writing, the subject software distributed under the License is distributed on an
//  "AS-IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. Refer to the
//  License for the specific language governing permissions and limitations.
//
//  Code Modification History:
//  ----------------------------------------------------------------------------------------------------
//  09/28/2009 - Mehulbhai P Thakkar
//       Generated original version of source code.
//
//******************************************************************************************************

using System;
using System.Windows.Data;
using System.Windows.Media;

namespace openPDCManager.Converters
{
	public class BooleanToColorConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
		{
            if (value == null)
                value = false;

			SolidColorBrush scBrush = new SolidColorBrush();

            if (parameter == null)  //if parameter is not supplied then we will return standard red and green color
            {
                if ((bool)value)
                    scBrush.Color = Color.FromArgb(255, 10, 255, 25);
                else
                    scBrush.Color = Color.FromArgb(255, 255, 10, 10);
            }
            else
            {
                if ((bool)value)
                    scBrush.Color = Color.FromArgb(00, 255, 255, 255);  //Transparent color
                else
                    scBrush.Color = Color.FromArgb(155, 10, 255, 25);
            }
			return scBrush as Brush;
		}

		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
		{
			return null;
		}

		#endregion
	}
}
